/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.verification.pluggable;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.rowset.CachedRowSet;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.pluggable.DataComparator;
import oracle.cluster.verification.pluggable.DataComparatorType;
import oracle.cluster.verification.pluggable.PluggableMsgType;
import oracle.cluster.verification.pluggable.PluggableTaskUtil;
import oracle.cluster.verification.pluggable.ReferenceInfo;
import oracle.cluster.verification.pluggable.ResultAnalyzerException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.InvalidRangeManipulationException;
import oracle.ops.verification.framework.util.RangeOfValue;
import oracle.ops.verification.framework.util.RangeOperator;
import oracle.ops.verification.framework.util.RangeType;

public class SQLDataComparator
extends DataComparator {
    protected String m_refColumn = null;
    protected String m_taskID = null;
    protected List<ReferenceInfo> m_columnReferenceList = null;
    protected List<String> m_columnNameList = null;
    protected boolean m_emptyResultSetImpliesSuccess = true;

    public SQLDataComparator(String taskID, String refColumn, List<String> columnNameList, List<ReferenceInfo> columnReferenceList, boolean emptyResultSetImpliesSuccess) {
        this.m_refColumn = refColumn;
        this.m_columnNameList = columnNameList;
        this.m_columnReferenceList = columnReferenceList;
        this.m_taskID = taskID;
        this.m_emptyResultSetImpliesSuccess = emptyResultSetImpliesSuccess;
    }

    @Override
    public ResultSet analyzeResult(ResultSet vfnResult) throws ResultAnalyzerException {
        ResultSet rsltSet = new ResultSet();
        Hashtable ht = vfnResult.getResultTable();
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            String dbName = (String)e.nextElement();
            Result result = (Result)ht.get(dbName);
            boolean resultSetEmpty = true;
            if (result.getStatus() == 1) {
                CachedRowSet collected = (CachedRowSet)result.getResultInfoSet().firstElement();
                try {
                    while (collected.next()) {
                        resultSetEmpty = false;
                        int columntCount = 1;
                        String refColumn = this.m_refColumn != null ? dbName + "(" + collected.getString(columntCount++) + ")" : dbName;
                        Result tempRes = new Result(refColumn);
                        String availableValue = this.getAvailableValue(collected, this.m_columnReferenceList);
                        String expectedValue = this.getExpectedValue(this.m_columnReferenceList);
                        tempRes.setActualValue(availableValue);
                        tempRes.setExpectedValue(expectedValue);
                        tempRes.setHasResultValues(true);
                        for (ReferenceInfo referenceInfo : this.m_columnReferenceList) {
                            String actualValue = this.getActualValue(collected, columntCount++);
                            try {
                                if (this.verify(actualValue, referenceInfo)) {
                                    tempRes.setStatus(1);
                                } else {
                                    tempRes.setStatus(3);
                                    String vfailMsg = new PluggableTaskUtil().getPluggableMsg(PluggableMsgType.TASK_VFAIL, this.m_taskID);
                                    tempRes.addErrorDescription(new ErrorDescription(vfailMsg));
                                }
                                rsltSet.addResult(refColumn, tempRes);
                            }
                            catch (VerificationException e1) {
                                rsltSet.addResult(refColumn, 2);
                                rsltSet.addErrorDescription(refColumn, new ErrorDescription(e1.getMessage()));
                            }
                        }
                    }
                    if (!resultSetEmpty) continue;
                    String refColumn = dbName;
                    Result tempRes = new Result(refColumn);
                    String availableValue = ReportUtil.UNDEFINED;
                    String expectedValue = this.getExpectedValue(this.m_columnReferenceList);
                    tempRes.setActualValue(availableValue);
                    tempRes.setExpectedValue(expectedValue);
                    tempRes.setHasResultValues(true);
                    if (this.m_emptyResultSetImpliesSuccess) {
                        tempRes.setStatus(1);
                        continue;
                    }
                    tempRes.setStatus(3);
                    String vfailMsg = new PluggableTaskUtil().getPluggableMsg(PluggableMsgType.TASK_VFAIL, this.m_taskID);
                    tempRes.addErrorDescription(new ErrorDescription(vfailMsg));
                }
                catch (SQLException e1) {
                    rsltSet.setStatus(2);
                    rsltSet.addErrorDescription(new ErrorDescription(e1.getMessage()));
                }
                continue;
            }
            Trace.out((String)("The status of execution result for node '" + dbName + "'+ is :" + Result.resultStatusString(result.getStatus()) + ";Hence skipped."));
            rsltSet.addResult(dbName, 2);
        }
        return rsltSet;
    }

    private String getExpectedValue(List<ReferenceInfo> m_columnReferenceList) {
        String value = "";
        for (int i = 0; i < m_columnReferenceList.size(); ++i) {
            ReferenceInfo referenceInfo = m_columnReferenceList.get(i);
            RangeOfValue expectedRange = null;
            String expected = null;
            if (i != 0) {
                value = value + "; ";
            }
            value = value + this.m_columnNameList.get(i);
            value = referenceInfo.getDataComparatorType() == DataComparatorType.NE ? value + " <> " : (referenceInfo.getDataComparatorType() == DataComparatorType.RE ? value + " ~ " : (referenceInfo.getDataComparatorType() == DataComparatorType.LE ? value + " <= " : (referenceInfo.getDataComparatorType() == DataComparatorType.LT ? value + " < " : (referenceInfo.getDataComparatorType() == DataComparatorType.GE ? value + " >= " : (referenceInfo.getDataComparatorType() == DataComparatorType.GT ? value + " > " : value + " = ")))));
            if (referenceInfo.getDataComparatorType() == DataComparatorType.RANGE) {
                expectedRange = (RangeOfValue)referenceInfo.getRefDataVal();
                value = value + expectedRange.toString();
                continue;
            }
            expected = ((String)referenceInfo.getRefDataVal()).trim();
            value = value + expected;
        }
        return value;
    }

    protected String getAvailableValue(CachedRowSet rowSet, List<ReferenceInfo> m_columnReferenceList) {
        String value = "";
        boolean first = true;
        int startIndex = this.m_refColumn != null ? 2 : 1;
        for (int i = 0; i < m_columnReferenceList.size(); ++i) {
            if (first) {
                first = false;
            } else {
                value = value + "; ";
            }
            value = value + this.m_columnNameList.get(i) + " = ";
            try {
                value = value + rowSet.getString(startIndex + i);
                continue;
            }
            catch (SQLException e) {
                Trace.out((Exception)e);
            }
        }
        return value;
    }

    protected String getActualValue(CachedRowSet rowSet, int colNo) throws SQLException {
        return rowSet.getString(colNo);
    }

    private boolean verify(String collected, ReferenceInfo referenceInfo) throws VerificationException {
        RangeOfValue expectedRange = null;
        String expected = null;
        if (referenceInfo.getDataComparatorType() == DataComparatorType.RANGE) {
            expectedRange = (RangeOfValue)referenceInfo.getRefDataVal();
        } else {
            expected = ((String)referenceInfo.getRefDataVal()).trim();
        }
        Trace.out((String)("expected=" + expected));
        Trace.out((String)("expectedRange=" + expectedRange));
        Trace.out((String)("collected=" + collected));
        Trace.out((String)("Datatype =" + (Object)((Object)referenceInfo.getDataType())));
        String obj = collected;
        RangeOfValue rov = null;
        switch (referenceInfo.getDataType()) {
            case STRING: {
                Trace.out((String)"Handling String datatype");
                try {
                    RangeOperator ro = this.getDataComparatorType(referenceInfo);
                    rov = new RangeOfValue(RangeType.STRING);
                    if (ro == null) {
                        Trace.out((String)"The given operator is not supported.");
                        throw new VerificationException(s_msgBundle.getMessage("0004", false));
                    }
                    rov.include(ro, expected);
                    if (!rov.contains(obj)) {
                        return false;
                    }
                }
                catch (InvalidRangeManipulationException irme) {
                    throw new VerificationException(irme.getMessage(), irme);
                }
                return true;
            }
            case NUMERIC: {
                if (expectedRange != null) {
                    try {
                        if (!expectedRange.contains(obj)) {
                            return false;
                        }
                    }
                    catch (InvalidRangeManipulationException irme) {
                        throw new VerificationException(irme.getMessage(), irme);
                    }
                    return true;
                }
                if (collected.lastIndexOf("-") > 0 || collected.lastIndexOf("+") > 0 || expected.lastIndexOf("-") > 0 || expected.lastIndexOf("+") > 0) {
                    Trace.out((String)"String is not Numeric.");
                    throw new VerificationException(s_msgBundle.getMessage("0005", false));
                }
                String tempCollected = collected.replaceFirst("[\\+\\-]", "0").replaceFirst("\\.", "0");
                String tempExpected = expected.replaceFirst("[\\+\\-]", "0").replaceFirst("\\.", "0");
                Pattern p = Pattern.compile("\\D");
                Matcher mc = p.matcher(tempCollected);
                Matcher me = p.matcher(tempExpected);
                if (mc.matches() || me.matches()) {
                    Trace.out((String)"String is not Numeric");
                    throw new VerificationException(s_msgBundle.getMessage("0005", false));
                }
                try {
                    rov = new RangeOfValue(collected.indexOf(".") > 0 || expected.indexOf(".") > 0 ? RangeType.FLOAT : RangeType.INTEGER);
                    RangeOperator ro = this.getDataComparatorType(referenceInfo);
                    if (ro == null) {
                        Trace.out((String)"Unable to get appropriate Operator");
                        throw new VerificationException(s_msgBundle.getMessage("0004", false));
                    }
                    rov.include(ro, expected);
                    if (!rov.contains(obj)) {
                        return false;
                    }
                }
                catch (InvalidRangeManipulationException irme) {
                    throw new VerificationException(irme.getMessage(), irme);
                }
                return true;
            }
            case VERSION: 
            case LIST: {
                throw new VerificationException("not supported");
            }
        }
        return false;
    }

    private RangeOperator getDataComparatorType(ReferenceInfo m_referenceInfo) {
        switch (m_referenceInfo.getDataComparatorType()) {
            case EQ: {
                return RangeOperator.EQ;
            }
            case EQ_NO_CASE: {
                return RangeOperator.EQ_NO_CASE;
            }
            case GE: {
                return RangeOperator.GE;
            }
            case LE: {
                return RangeOperator.LE;
            }
            case GT: {
                return RangeOperator.GT;
            }
            case LT: {
                return RangeOperator.LT;
            }
            case NE: {
                return RangeOperator.NE;
            }
            case RE: {
                return RangeOperator.RE;
            }
        }
        return null;
    }
}

